/*
 * Decompiled with CFR 0.152.
 */
package elocindev.prominent.mixin.capital_cities;

import elocindev.prominent.ProminentLoader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3949;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class LoadCapitalCitiesMixin {
    @Inject(method={"createWorlds"}, at={@At(value="HEAD")})
    private void beforeCreateWorlds(class_3949 listener, CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        Path configDims = FabricLoader.getInstance().getConfigDir().resolve("prominent").resolve("dimensions");
        Path worldRoot = server.method_27050(class_5218.field_24188);
        Path worldDims = worldRoot.resolve("dimensions").resolve("prominent");
        try {
            if (Files.exists(worldDims, new LinkOption[0])) {
                this.deleteRecursive(worldDims);
            }
            if (Files.exists(configDims, new LinkOption[0])) {
                this.copyRecursive(configDims, worldDims);
            }
        }
        catch (IOException e) {
            ProminentLoader.LOGGER.error("Failed to override prominent dimensions", (Throwable)e);
        }
    }

    private void deleteRecursive(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
                for (Path entry : entries) {
                    this.deleteRecursive(entry);
                }
            }
        }
        Files.deleteIfExists(path);
    }

    private void copyRecursive(Path source, Path target) throws IOException {
        Files.walk(source, new FileVisitOption[0]).forEach(src -> {
            try {
                Path rel = source.relativize((Path)src);
                Path dest = target.resolve(rel);
                if (Files.isDirectory(src, new LinkOption[0])) {
                    Files.createDirectories(dest, new FileAttribute[0]);
                } else {
                    Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }
}

