/*
 * Decompiled with CFR 0.152.
 */
package elocindev.prominent;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import elocindev.necronomicon.api.config.v1.NecConfigAPI;
import elocindev.prominent.commands.CommandRegistry;
import elocindev.prominent.config.BossLevels;
import elocindev.prominent.config.ItemLevels;
import elocindev.prominent.config.ServerConfig;
import elocindev.prominent.mythicbosses.MythicBosses;
import elocindev.prominent.player.artifact.AritfactAttributes;
import elocindev.prominent.registry.AttributeRegistry;
import elocindev.prominent.registry.BlockRegistry;
import elocindev.prominent.registry.EffectRegistry;
import elocindev.prominent.registry.ItemRegistry;
import elocindev.prominent.registry.SoundRegistry;
import elocindev.prominent.registry.StatRegistry;
import elocindev.prominent.registry.TabRegistry;
import elocindev.prominent.spells.misc.OnCombat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProminentLoader
implements ModInitializer {
    public static final String MODID = "prominent";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"prominent");
    public static Random RANDOM = new Random();
    public static ServerConfig Config;
    public static BossLevels BossLevelConfig;
    public static ItemLevels ItemLevelsConfig;

    public void onInitialize() {
        NecConfigAPI.registerConfig(ServerConfig.class);
        NecConfigAPI.registerConfig(BossLevels.class);
        NecConfigAPI.registerConfig(ItemLevels.class);
        Config = ServerConfig.INSTANCE;
        BossLevelConfig = BossLevels.INSTANCE;
        ItemLevelsConfig = ItemLevels.INSTANCE;
        AttributeRegistry.register();
        SoundRegistry.registerSounds();
        EffectRegistry.register();
        BlockRegistry.registerBlocks();
        ItemRegistry.registerItems();
        TabRegistry.register();
        CommandRegistry.register();
        MythicBosses.registerDrops();
        MythicBosses.registerBuff();
        StatRegistry.register();
        OnCombat.regsiter();
        AritfactAttributes.register();
    }

    private boolean isValidManifest() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return true;
        }
        Path mainDirectory = FabricLoader.getInstance().getGameDir();
        Path manifestPath = mainDirectory.resolve("manifest.json");
        if (Files.exists(manifestPath, new LinkOption[0])) {
            try {
                boolean check;
                String content = new String(Files.readAllBytes(manifestPath));
                JsonObject jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
                String author = jsonObject.has("author") ? jsonObject.get("author").getAsString() : "";
                String modpack = jsonObject.has("name") ? jsonObject.get("name").getAsString() : "";
                boolean bl = check = author != "" && modpack != "" && "ElocinDev".equals(author) && "Prominence II RPG Hasturian Era".equals(modpack);
                if (!check) {
                    LOGGER.error("Hello there! You seem to be using Prominent in a modified version of Prominence (or another pack that isn't Prominence). Keep in mind this is not allowed, both Prominent and Prominence have a strict license that does not allow redistribution or public modification, making this either an illegal reupload of Prominence, or a an illegal redistribution of Prominent, as Prominent is not available through CurseForge, so you're also breaking the license of Prominent by overriding the file within the modpack. ");
                }
                return check;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

